/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;

public class ExtractCoord
extends GeometryFunction {
    protected final int indCoord;
    protected GeometryFunction.GeometryValue<PointFunction> point;

    public ExtractCoord(int n, GeometryFunction.GeometryValue<PointFunction> geometryValue) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (n <= 0 || n > 2) {
            throw new ArrayIndexOutOfBoundsException("Impossible to extract another coordinate that the two first: only COORD1 and COORD2 exists in ADQL !");
        }
        this.indCoord = n;
        if (geometryValue == null) {
            throw new NullPointerException("Impossible to build a COORD" + this.indCoord + " function without a point (a POINT function or a column which contains a POINT function) !");
        }
        this.point = geometryValue;
    }

    public ExtractCoord(ExtractCoord extractCoord) throws Exception {
        this.indCoord = extractCoord.indCoord;
        this.point = (GeometryFunction.GeometryValue)extractCoord.point.getCopy();
    }

    @Override
    public String getName() {
        return "COORD" + this.indCoord;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ExtractCoord(this);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.point.getValue()};
    }

    @Override
    public int getNbParameters() {
        return 1;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        if (n == 0) {
            return this.point.getValue();
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (n == 0) {
            if (aDQLOperand == null) {
                throw new NullPointerException("Impossible to remove the only required parameter of the function " + this.getName() + " !");
            }
            ADQLOperand aDQLOperand2 = this.point.getValue();
            if (aDQLOperand instanceof GeometryFunction.GeometryValue) {
                this.point = (GeometryFunction.GeometryValue)aDQLOperand;
            } else if (aDQLOperand instanceof ADQLColumn) {
                this.point.setColumn((ADQLColumn)aDQLOperand);
            } else if (aDQLOperand instanceof PointFunction) {
                this.point.setGeometry((PointFunction)aDQLOperand);
            } else {
                throw new Exception("Impossible to replace GeometryValue/Column/PointFunction by a " + aDQLOperand.getClass().getName() + " (" + aDQLOperand.toADQL() + ") !");
            }
            return aDQLOperand2;
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }
}

